#!/bin/bash
# ======================================
# Launcher for publish/CppDepend.Console
# Ensures all executables are runnable
# ======================================

# Resolve the script's directory
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
LIBS_DIR="$SCRIPT_DIR/libs"
APP_PATH="$LIBS_DIR/XDepend.GUI"

# External tools
CLANG_PATH="$LIBS_DIR/ProgrammingLanguages/Cpp/clang"
CLANGTIDY_PATH="$LIBS_DIR/ProgrammingLanguages/Cpp/plugins/clang-tidy"
CPPCHECK_PATH="$LIBS_DIR/ProgrammingLanguages/Cpp/plugins/cppcheck"

# Verify libs folder exists
if [ ! -d "$LIBS_DIR" ]; then
  echo "❌ Error: libs folder not found at $LIBS_DIR"
  exit 1
fi

# --- Function to ensure a binary is executable ---
ensure_executable() {
  local FILE_PATH="$1"
  local LABEL="$2"

  if [ ! -f "$FILE_PATH" ]; then
    echo "⚠️  Warning: $LABEL not found at $FILE_PATH"
    return
  fi

  if [ ! -x "$FILE_PATH" ]; then
    echo "⚙️  Fixing permissions for $LABEL..."
    chmod u+x "$FILE_PATH" 2>/dev/null
    if [ $? -ne 0 ]; then
      echo "❌ Failed to set execute permission for $LABEL ($FILE_PATH)"
      echo "   Try manually: chmod +x \"$FILE_PATH\""
    fi
  fi
}

# Ensure all needed executables are runnable
ensure_executable "$APP_PATH" "XDepend.GUI"
ensure_executable "$APP_PATH" "CppDepend.Console"
ensure_executable "$CLANG_PATH" "clang"
ensure_executable "$CLANGTIDY_PATH" "clang-tidy"
ensure_executable "$CPPCHECK_PATH" "cppcheck"

# Run the Console app with all passed arguments
if [ ! -x "$APP_PATH" ]; then
  echo "❌ Cannot launch: $APP_PATH is not executable."
  exit 1
fi

echo "🚀 Launching VisualCppDepend..."
"$APP_PATH" "$@"

