/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cppdepend;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.cppdepend.NDependIssue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IssuesResultParser {
    private final Document doc;
    private final XPath xpath;
    private final List<NDependIssue> issueBuilder;
    private static final Logger LOG = LoggerFactory.getLogger(IssuesResultParser.class);

    IssuesResultParser(Document doc) {
        this.doc = doc;
        this.xpath = XPathFactory.newInstance().newXPath();
        this.issueBuilder = new ArrayList<NDependIssue>();
    }

    public static IssuesResultParser fromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new IssuesResultParser(factory.newDocumentBuilder().parse(file));
    }

    NodeList getIssues(String projectName) throws XPathExpressionException {
        return (NodeList)this.xpath.compile("//Issue").evaluate(this.doc, XPathConstants.NODESET);
    }

    public List<NDependIssue> parse(String projectName) throws XPathExpressionException {
        NodeList issues = this.getIssues(projectName);
        for (int j = 0; j < issues.getLength(); ++j) {
            Element row = (Element)issues.item(j);
            String filePath = row.getAttribute("Path");
            File file = new File(filePath);
            if (!file.exists()) continue;
            String ruleKey = StringEscapeUtils.escapeXml((String)row.getAttribute("Name").replace(" ", "").replace(",", ""));
            String ruleDesc = row.getAttribute("Name");
            int fileLine = Integer.parseInt(row.getAttribute("Line"));
            int debt = Integer.parseInt(row.getAttribute("Debt"));
            String severity = row.getAttribute("Severity");
            this.issueBuilder.add(new NDependIssue(ruleKey, ruleDesc, file, fileLine, debt, severity));
        }
        return this.issueBuilder;
    }
}

