/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cppdepend;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.cppdepend.IssuesResultParser;
import org.sonar.plugins.cppdepend.NDependConfiguration;
import org.sonar.plugins.cppdepend.NDependExecutor;
import org.sonar.plugins.cppdepend.NDependIssue;

public final class NDependSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(NDependSensor.class);
    private ActiveRules rules;
    private final NDependConfiguration conf;
    private static Boolean analysisdone = false;
    private final Configuration configuration;

    public NDependSensor(Configuration configuration, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, ActiveRules rules) {
        this.rules = rules;
        this.configuration = configuration;
        this.conf = new NDependConfiguration(configuration);
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("cxx").name("CppDependSensor");
    }

    public void execute(SensorContext context) {
        LOG.debug("Begin cppdepend analysis");
        this.analyze(context, new NDependExecutor());
    }

    void analyze(SensorContext sensorContext, NDependExecutor executor) {
        String reportPath = this.conf.reportPathPropertyKey();
        if (reportPath == null) {
            if (this.configuration.get("sonar.cpp.cppdepend.projectPath").orElse(null) == null) {
                LOG.info("CppDepend analysis skipped because no project file is specified. You have to define the sonar.cpp.cppdepend.projectPath key");
                return;
            }
            File projectFile = new File(this.configuration.get("sonar.cpp.cppdepend.projectPath").orElse(null));
            if (!projectFile.exists()) {
                LOG.info("CppDepend analysis skipped because no project file is specified. You have to define the sonar.cpp.cppdepend.projectPath key");
                return;
            }
            if (this.configuration.get("sonar.cpp.cppdepend.ruleRunnerPath").orElse(null) == null) {
                LOG.error("CppDepend analysis skipped because  the CppDepend SonarQube Rules Runner path is not configured, Please contact your server admin to set this path.");
                return;
            }
            File scannerFile = new File(this.configuration.get("sonar.cpp.cppdepend.ruleRunnerPath").orElse(null));
            if (!scannerFile.exists()) {
                LOG.error("CppDepend analysis skipped because  the CppDepend SonarQube Rules Runner path  is not valid, Please contact your server admin to set a valid path.");
                return;
            }
            File reportFile = new File(sensorContext.fileSystem().workDir().getParent(), "cppdepend-report.xml");
            boolean runAnalysis = false;
            String runAnalysisValue = this.configuration.get("sonar.cpp.cppdepend.runAnalysis").orElse(null);
            if (runAnalysisValue == null || "true".equals(runAnalysisValue)) {
                if (!analysisdone.booleanValue()) {
                    executor.execute(this.conf.ruleRunnerPath(), this.conf.ndependProjectPath(), runAnalysis, reportFile);
                    analysisdone = true;
                }
            } else {
                LOG.debug("Using the provided CppDepend report " + reportPath);
                reportFile = new File(reportPath);
            }
            if (reportFile.exists()) {
                List<NDependIssue> issues;
                try {
                    issues = IssuesResultParser.fromFile(reportFile).parse(sensorContext.config().get("sonar.projectName").orElse(null));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                for (NDependIssue issue : issues) {
                    InputFile inputFile = sensorContext.fileSystem().inputFile(sensorContext.fileSystem().predicates().is(issue.getFile()));
                    if (inputFile == null) continue;
                    try {
                        RuleKey rulekey = RuleKey.of((String)"cppdepend", (String)issue.getRuleKey());
                        if (rulekey == null) continue;
                        NewIssue newIssue = sensorContext.newIssue().forRule(RuleKey.of((String)"cppdepend", (String)issue.getRuleKey()));
                        NewIssueLocation location = newIssue.newLocation().on((InputComponent)inputFile).at(inputFile.selectLine(issue.getLine())).message(issue.getMessage());
                        newIssue.at(location);
                        newIssue.gap(Double.valueOf(issue.getDebt()));
                        if (issue.getSeverity().equals("Blocker")) {
                            newIssue.overrideSeverity(Severity.BLOCKER);
                        } else if (issue.getSeverity().equals("Critical")) {
                            newIssue.overrideSeverity(Severity.CRITICAL);
                        } else if (issue.getSeverity().equals("High") || issue.getSeverity().equals("Major")) {
                            newIssue.overrideSeverity(Severity.MAJOR);
                        } else if (issue.getSeverity().equals("Medium") || issue.getSeverity().equals("Minor")) {
                            newIssue.overrideSeverity(Severity.MINOR);
                        } else if (issue.getSeverity().equals("Low") || issue.getSeverity().equals("Info")) {
                            newIssue.overrideSeverity(Severity.INFO);
                        }
                        newIssue.save();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

