/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cppdepend.c;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RulesCreator {
    private final Document doc;
    private final XPath xpath;
    private static final Logger LOG = LoggerFactory.getLogger(RulesCreator.class);

    RulesCreator(Document doc) {
        this.doc = doc;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public static RulesCreator fromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new RulesCreator(factory.newDocumentBuilder().parse(file));
    }

    public static RulesCreator fromFile(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new RulesCreator(factory.newDocumentBuilder().parse(is));
    }

    @VisibleForTesting
    NodeList getGroups() throws XPathExpressionException {
        return (NodeList)this.xpath.compile("//Group").evaluate(this.doc, XPathConstants.NODESET);
    }

    @VisibleForTesting
    NodeList getQueries(Node queryNode) throws XPathExpressionException {
        return (NodeList)this.xpath.compile("Query").evaluate(queryNode, XPathConstants.NODESET);
    }

    public String parse() throws XPathExpressionException {
        HashSet<String> hs = new HashSet<String>();
        NodeList groups = this.getGroups();
        StringBuilder rulesxml = new StringBuilder();
        rulesxml.append("<rules>\n");
        for (int i = 0; i < groups.getLength(); ++i) {
            Node group = groups.item(i);
            NodeList rows = this.getQueries(groups.item(i));
            String groupname = "";
            Boolean isactive = true;
            if (((Element)group).getAttribute("Name") != null && !((Element)group).getAttribute("Name").trim().isEmpty()) {
                groupname = ((Element)group).getAttribute("Name");
            }
            if (((Element)group).getAttribute("Active") != null && ((Element)group).getAttribute("Active").equals("False")) {
                isactive = false;
            }
            if (!isactive.booleanValue() || groupname.equals("CppCheck Queries") || groupname.equals("Diagnostics Queries") || groupname.equals("Plugins") || groupname.equals("Sonar Metrics") || groupname.equals("CPD Queries") || groupname.equals("API Breaking Changes") || groupname.equals("Code Diff Summary") || groupname.equals("Visibility") || groupname.equals("Naming Conventions") || groupname.equals("Source Files Organization") || groupname.equals("Statistics")) continue;
            for (int j = 0; j < rows.getLength(); ++j) {
                Element row = (Element)rows.item(j);
                Boolean isqueryactive = true;
                Boolean iscritical = false;
                String queryname = "";
                if (row.getAttribute("Active") != null && row.getAttribute("Active").equals("False")) {
                    isqueryactive = false;
                }
                if (row.getAttribute("IsCriticalRule") != null && row.getAttribute("IsCriticalRule").equals("True")) {
                    iscritical = true;
                }
                String querytext = row.getTextContent();
                querytext = querytext.replaceAll("\n", "\r\n");
                querytext = querytext.replaceAll("\r", "\r\n");
                String ruleType = "";
                if (querytext.contains("CppCheck") && querytext.contains("Severity.High")) {
                    ruleType = "BUG";
                }
                if ((querytext.contains("CppCheck") || querytext.contains("Clang")) && (querytext.contains("printf") || querytext.contains("scanf"))) {
                    ruleType = "VULNERABILITY";
                }
                int bname = querytext.indexOf("<Name>");
                int ename = querytext.indexOf("</Name>");
                queryname = bname > 0 && ename > 0 && bname < ename ? querytext.substring(bname + 6, ename) : "NotNamedQuery";
                if ((queryname = StringEscapeUtils.escapeXml((String)queryname)).length() >= 200) {
                    queryname = queryname.substring(0, 199);
                }
                if (!isqueryactive.booleanValue() || hs.contains(queryname) || queryname.equals("NotNamedQuery")) continue;
                hs.add(queryname);
                rulesxml.append("<rule>\n");
                rulesxml.append("<key>" + StringEscapeUtils.escapeXml((String)queryname.replace(" ", "").replace(",", "")) + "</key>");
                if (iscritical.booleanValue()) {
                    rulesxml.append("<severity>MAJOR</severity>");
                } else {
                    rulesxml.append("<severity>MINOR</severity>");
                }
                if (ruleType.equals("BUG") || ruleType.equals("VULNERABILITY")) {
                    rulesxml.append("<type>" + ruleType + "</type>");
                }
                rulesxml.append("<name>" + queryname + "</name>");
                rulesxml.append("<group>" + groupname + "</group>");
                rulesxml.append("<remediationFunction>LINEAR_OFFSET</remediationFunction>");
                rulesxml.append("<remediationFunctionGapMultiplier>1min</remediationFunctionGapMultiplier>");
                rulesxml.append("<remediationFunctionBaseEffort>0min</remediationFunctionBaseEffort>");
                rulesxml.append("<description><![CDATA[" + queryname + "]]></description>");
                rulesxml.append("</rule>\n");
            }
        }
        rulesxml.append("</rules>\n");
        return rulesxml.toString();
    }
}

