/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jarchitect;

import java.io.File;
import org.sonar.api.config.Configuration;

public class JArchitectConfiguration {
    private final Configuration settings;

    public JArchitectConfiguration(Configuration settings) {
        this.settings = settings;
    }

    public String ruleRunnerPath() {
        return this.checkAbsolutePath("sonar.java.jarchitect.ruleRunnerPath");
    }

    public String jarchitectProjectPathForRule() {
        return this.checkAbsolutePath("sonar.java.jarchitect.projectPathForRules");
    }

    public String jarchitectProjectPath() {
        return this.checkAbsolutePath("sonar.java.jarchitect.projectPath");
    }

    public String reportPathPropertyKey() {
        String reportPath = this.settings.get("sonar.java.jarchitect.reportPath").orElse(null);
        if (reportPath == null) {
            return null;
        }
        return this.checkAbsolutePath("sonar.java.jarchitect.reportPath");
    }

    public int timeout() {
        return this.settings.getInt("sonar.java.jarchitect.timeoutMinutes").orElse(0);
    }

    private String checkAbsolutePath(String property) {
        File file;
        String path = this.settings.get(property).orElse(null);
        if (property == null) {
            System.out.println("The property \"" + property + "\" must be set (to an absolute path).");
        }
        if (!(file = new File(path)).isAbsolute()) {
            System.out.println("The property \"" + property + "\" must be set (to an absolute path).");
        }
        if (!file.exists()) {
            System.out.println("The absolute path provided in the property \"" + property + "\" does not exist: " + path);
        }
        return path;
    }
}

