/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jarchitect;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;
import org.sonar.plugins.jarchitect.JArchitectConfiguration;
import org.sonar.plugins.jarchitect.RulesCreator;

public class JArchitectRulesDefinition
implements RulesDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(JArchitectRulesDefinition.class);
    private final RulesDefinitionXmlLoader xmlLoader;
    private Configuration settings;
    private final JArchitectConfiguration conf;

    public JArchitectRulesDefinition(RulesDefinitionXmlLoader xmlLoader, Configuration settings) {
        this.xmlLoader = xmlLoader;
        this.settings = settings;
        this.conf = new JArchitectConfiguration(this.settings);
    }

    public void define(RulesDefinition.Context context) {
        LOG.info("Defining rules for JArchitect...");
        RulesDefinition.NewRepository repository = context.createRepository("jarchitect", "java");
        repository.setName("JArchitect");
        try {
            String rulespath = this.settings.get("sonar.java.jarchitect.projectPath").orElse(null);
            if (!"".equals(rulespath) && rulespath != null) {
                File f = new File(rulespath);
                if (f.exists() && !f.isDirectory()) {
                    File rulesFile = new File(rulespath);
                    String rules = RulesCreator.fromFile(rulesFile).parse();
                    ByteArrayInputStream stream = new ByteArrayInputStream(rules.getBytes(StandardCharsets.UTF_8));
                    this.xmlLoader.load(repository, (Reader)new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                }
            } else {
                InputStream xmlStream = this.getClass().getResourceAsStream("/Template.jdproj");
                String rules = RulesCreator.fromFile(xmlStream).parse();
                ByteArrayInputStream stream = new ByteArrayInputStream(rules.getBytes(StandardCharsets.UTF_8));
                this.xmlLoader.load(repository, (Reader)new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            LOG.error("Failed to retrieve rules: please check that you already define the sonar.java.jarchitect.projectPathForRules variable", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve rules: please check that you already define the sonar.java.jarchitect.projectPathForRules variable", (Throwable)e);
        }
        repository.done();
    }

    private static class ParseErrorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseErrorException(String message) {
            super(message);
        }
    }

    private static class JArchitectRulesParser {
        private final RulesDefinition.NewRepository repository;
        private XMLStreamReader stream;

        public JArchitectRulesParser(RulesDefinition.NewRepository repository) {
            this.repository = repository;
        }

        public void parse(String xml) {
            StringReader reader = null;
            XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
            try {
                reader = new StringReader(xml);
                this.stream = xmlFactory.createXMLStreamReader(reader);
                while (this.stream.hasNext()) {
                    String tagName;
                    if (this.stream.next() != 1 || !"Rule".equals(tagName = this.stream.getLocalName())) continue;
                    this.handleRuleTag();
                }
            }
            catch (XMLStreamException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.closeXmlStream();
                Closeables.closeQuietly((Closeable)reader);
            }
        }

        private void closeXmlStream() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (XMLStreamException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }

        private void handleRuleTag() throws XMLStreamException {
            String key = this.getRequiredAttribute("Key");
            String priority = this.getRequiredAttribute("Priority");
            String category = this.getAttribute("Category");
            String name = null;
            String description = this.stream.getElementText();
            int indexbegin_desc = description.indexOf("<Description>");
            int indexend_desc = description.indexOf("</Description>");
            int indexbegin_fix = description.indexOf("<HowToFix>");
            int indexend_fix = description.indexOf("</HowToFix>");
            if (indexbegin_desc > 0 && indexend_desc > 0) {
                Object desc = description.substring(indexbegin_desc, indexend_desc);
                if (indexbegin_fix > 0 && indexend_fix > 0) {
                    desc = (String)desc + "\n" + description.substring(indexbegin_fix, indexend_fix);
                }
                description = desc;
            } else {
                description = "";
            }
            while (this.stream.hasNext()) {
                int next = this.stream.next();
                if (next == 2 && "Rule".equals(this.stream.getLocalName())) {
                    if (name == null) {
                        throw this.parseError("Missing rule name");
                    }
                    if (description == null) {
                        throw this.parseError("Missing rule description");
                    }
                    RulesDefinition.NewRule rule = this.repository.createRule(key).setName(name).setSeverity(priority).setHtmlDescription(description);
                    rule.setDebtRemediationFunction(rule.debtRemediationFunctions().linearWithOffset("1min", "0min"));
                    if (category == null) break;
                    rule.addTags(new String[]{category});
                    break;
                }
                if (next != 1) continue;
                String tagName = this.stream.getLocalName();
                if ("Name".equals(tagName)) {
                    name = this.stream.getElementText();
                    continue;
                }
                if (!"Description".equals(tagName)) continue;
                description = this.stream.getElementText();
            }
        }

        public String getRequiredAttribute(String name) {
            String value = this.getAttribute(name);
            if (value == null) {
                throw this.parseError("Missing attribute \"" + name + "\" in element <" + this.stream.getLocalName() + ">");
            }
            return value;
        }

        public String getAttribute(String name) {
            for (int i = 0; i < this.stream.getAttributeCount(); ++i) {
                if (!name.equals(this.stream.getAttributeLocalName(i))) continue;
                return this.stream.getAttributeValue(i);
            }
            return null;
        }

        public ParseErrorException parseError(String message) {
            return new ParseErrorException(message + " at line " + this.stream.getLocation().getLineNumber());
        }
    }
}

