/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jarchitect;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.jarchitect.IssuesResultParser;
import org.sonar.plugins.jarchitect.JArchitectConfiguration;
import org.sonar.plugins.jarchitect.JArchitectExecutor;
import org.sonar.plugins.jarchitect.JArchitectIssue;

public final class JArchitectSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(JArchitectSensor.class);
    private ActiveRules rules;
    private final JArchitectConfiguration conf;
    private Configuration settings;

    public JArchitectSensor(Configuration settings, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, ActiveRules rules) {
        this.rules = rules;
        this.settings = settings;
        this.conf = new JArchitectConfiguration(settings);
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("java").name("JArchitectSensor");
    }

    public void execute(SensorContext context) {
        this.analyze(context, new JArchitectExecutor());
    }

    void analyze(SensorContext sensorContext, JArchitectExecutor executor) {
        List<JArchitectIssue> issues;
        File reportFile;
        if (!this.settings.get("sonar.java.jarchitect.projectPath").isPresent()) {
            LOG.info("JArchitect analysis skipped because no project file is specified. You have to define the sonar.java.jarchitect.projectPath key");
            return;
        }
        File projectFile = new File((String)this.settings.get("sonar.java.jarchitect.projectPath").get());
        if (!projectFile.exists()) {
            LOG.info("JArchitect analysis skipped because no project file is specified. You have to define the sonar.java.jarchitect.projectPath key");
            return;
        }
        if (!this.settings.get("sonar.java.jarchitect.ruleRunnerPath").isPresent()) {
            LOG.error("JArchitect analysis skipped because  the JArchitect SonarQube Rules Runner path is not configured, Please contact your server admin to set this path.");
            return;
        }
        String reportPath = this.conf.reportPathPropertyKey();
        if (reportPath == null) {
            reportFile = new File(sensorContext.fileSystem().workDir().getParent(), "jarchitect-report.xml");
            executor.execute(this.conf.ruleRunnerPath(), this.conf.jarchitectProjectPath(), reportFile, this.conf.timeout());
        } else {
            LOG.debug("Using the provided JArchitect report " + reportPath);
            reportFile = new File(reportPath);
        }
        try {
            issues = IssuesResultParser.fromFile(reportFile).parse(this.settings.get("sonar.projectName").orElse(null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (JArchitectIssue issue : issues) {
            InputFile inputFile = sensorContext.fileSystem().inputFile(sensorContext.fileSystem().predicates().is(issue.getFile()));
            if (inputFile == null) continue;
            try {
                RuleKey rulekey = RuleKey.of((String)"jarchitect", (String)issue.getRuleKey());
                if (rulekey == null) continue;
                NewIssue newIssue = sensorContext.newIssue().forRule(RuleKey.of((String)"jarchitect", (String)issue.getRuleKey()));
                NewIssueLocation location = newIssue.newLocation().on((InputComponent)inputFile).at(inputFile.selectLine(issue.getLine())).message(issue.getMessage());
                newIssue.at(location);
                newIssue.gap(Double.valueOf(issue.getDebt()));
                if (issue.getSeverity().equals("Blocker")) {
                    newIssue.overrideSeverity(Severity.BLOCKER);
                } else if (issue.getSeverity().equals("Critical")) {
                    newIssue.overrideSeverity(Severity.CRITICAL);
                } else if (issue.getSeverity().equals("High") || issue.getSeverity().equals("Major")) {
                    newIssue.overrideSeverity(Severity.MAJOR);
                } else if (issue.getSeverity().equals("Medium") || issue.getSeverity().equals("Minor")) {
                    newIssue.overrideSeverity(Severity.MINOR);
                } else if (issue.getSeverity().equals("Low") || issue.getSeverity().equals("Info")) {
                    newIssue.overrideSeverity(Severity.INFO);
                }
                newIssue.save();
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

