/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jarchitect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RulesCreator {
    private final Document doc;
    private final XPath xpath;
    private static final Logger LOG = LoggerFactory.getLogger(RulesCreator.class);

    RulesCreator(Document doc) {
        this.doc = doc;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public static RulesCreator fromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new RulesCreator(factory.newDocumentBuilder().parse(file));
    }

    public static RulesCreator fromFile(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new RulesCreator(factory.newDocumentBuilder().parse(is));
    }

    ArrayList<NodeList> getGroups() throws XPathExpressionException {
        ArrayList<NodeList> allgroups = new ArrayList<NodeList>();
        NodeList primaryGroup = (NodeList)this.xpath.compile("//Group").evaluate(this.doc, XPathConstants.NODESET);
        allgroups.add(primaryGroup);
        NodeList ruleFiles = (NodeList)this.xpath.compile("//RuleFile").evaluate(this.doc, XPathConstants.NODESET);
        for (int i = 0; i < ruleFiles.getLength(); ++i) {
            String path;
            File f;
            Node ruleFile = ruleFiles.item(i);
            if (((Element)ruleFile).getAttribute("Active") == null || !((Element)ruleFile).getAttribute("Active").equals("True") || !(f = new File(path = ((Element)ruleFile).getAttribute("Path"))).exists() || f.isDirectory()) continue;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document ruleDocument = factory.newDocumentBuilder().parse(path);
                NodeList ruleFileGroups = (NodeList)this.xpath.compile("//Group").evaluate(ruleDocument, XPathConstants.NODESET);
                allgroups.add(ruleFileGroups);
                NodeList ruleFileQueries = (NodeList)this.xpath.compile("//Queries").evaluate(ruleDocument, XPathConstants.NODESET);
                allgroups.add(ruleFileQueries);
                continue;
            }
            catch (SAXException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException | ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        return allgroups;
    }

    NodeList getQueries(Node queryNode) throws XPathExpressionException {
        return (NodeList)this.xpath.compile("Query").evaluate(queryNode, XPathConstants.NODESET);
    }

    public String parse() throws XPathExpressionException {
        HashSet<String> hs = new HashSet<String>();
        ArrayList<NodeList> allgroups = this.getGroups();
        StringBuilder rulesxml = new StringBuilder();
        rulesxml.append("<rules>\n");
        for (int ig = 0; ig < allgroups.size(); ++ig) {
            NodeList groups = allgroups.get(ig);
            for (int i = 0; i < groups.getLength(); ++i) {
                Node group = groups.item(i);
                NodeList rows = this.getQueries(groups.item(i));
                String groupname = "";
                Boolean isactive = true;
                if (((Element)group).getAttribute("Name") != null && !((Element)group).getAttribute("Name").trim().isEmpty()) {
                    groupname = ((Element)group).getAttribute("Name");
                }
                if (((Element)group).getAttribute("Active") != null && ((Element)group).getAttribute("Active").equals("False")) {
                    isactive = false;
                }
                if (!isactive.booleanValue()) continue;
                for (int j = 0; j < rows.getLength(); ++j) {
                    Element row = (Element)rows.item(j);
                    Boolean isqueryactive = true;
                    Boolean iscritical = false;
                    String queryname = "";
                    if (row.getAttribute("Active") != null && row.getAttribute("Active").equals("False")) {
                        isqueryactive = false;
                    }
                    if (row.getAttribute("IsCriticalRule") != null && row.getAttribute("IsCriticalRule").equals("True")) {
                        iscritical = true;
                    }
                    String querytext = row.getTextContent();
                    querytext = querytext.replaceAll("\n", "\r\n");
                    querytext = querytext.replaceAll("\r", "\r\n");
                    Boolean isrule = false;
                    if (querytext.indexOf("warnif") > 0) {
                        isrule = true;
                    }
                    int bname = querytext.indexOf("<Name>");
                    int ename = querytext.indexOf("</Name>");
                    queryname = bname > 0 && ename > 0 && bname < ename ? querytext.substring(bname + 6, ename) : "NotNamedQuery";
                    if ((queryname = StringEscapeUtils.escapeXml((String)queryname)).length() >= 200) {
                        queryname = queryname.substring(0, 199);
                    }
                    Object description = querytext;
                    int indexbegin_desc = ((String)description).indexOf("<Description>");
                    int indexend_desc = ((String)description).indexOf("</Description>");
                    int indexbegin_fix = ((String)description).indexOf("<HowToFix>");
                    int indexend_fix = ((String)description).indexOf("</HowToFix>");
                    if (indexbegin_desc > 0 && indexend_desc > 0) {
                        Object desc = this.formatReferences(((String)description).substring(indexbegin_desc, indexend_desc));
                        desc = "<p><b>Description:</b>" + (String)desc + "</p>";
                        if (indexbegin_fix > 0 && indexend_fix > 0) {
                            String HowToFix = this.formatReferences(((String)description).substring(indexbegin_fix, indexend_fix));
                            desc = (String)desc + "<p><b>How To Fix:</b>" + HowToFix + "</p>";
                        }
                        description = desc;
                    } else {
                        description = queryname;
                    }
                    description = ((String)description).replaceAll("\\/\\/", "");
                    description = ((String)description).replaceAll("http:", "http://");
                    description = ((String)description).replaceAll("<Description>", "");
                    description = ((String)description).replaceAll("<HowToFix>", "");
                    description = ((String)description).replaceAll("\r\n", "<br/>");
                    if (!isqueryactive.booleanValue() || hs.contains(queryname) || queryname.equals("NotNamedQuery") || !isrule.booleanValue()) continue;
                    hs.add(queryname);
                    rulesxml.append("<rule>\n");
                    rulesxml.append("<key>" + StringEscapeUtils.escapeXml((String)queryname.replace(" ", "").replace(",", "")) + "</key>");
                    if (iscritical.booleanValue()) {
                        rulesxml.append("<severity>MAJOR</severity>");
                    } else {
                        rulesxml.append("<severity>MINOR</severity>");
                    }
                    rulesxml.append("<name>" + queryname + "</name>");
                    if (!"".equals(groupname)) {
                        rulesxml.append("<group>" + groupname + "</group>");
                    }
                    rulesxml.append("<remediationFunction>LINEAR_OFFSET</remediationFunction>");
                    rulesxml.append("<remediationFunctionGapMultiplier>1min</remediationFunctionGapMultiplier>");
                    rulesxml.append("<remediationFunctionBaseEffort>0min</remediationFunctionBaseEffort>");
                    rulesxml.append("<description><![CDATA[" + (String)description + "]]></description>");
                    rulesxml.append("<descriptionFormat>HTML</descriptionFormat>");
                    rulesxml.append("</rule>\n");
                }
            }
        }
        rulesxml.append("</rules>\n");
        return rulesxml.toString();
    }

    String formatReferences(String description) {
        Object ret = description;
        int index_begin = description.indexOf("http:");
        int index_end = -1;
        int offset = 0;
        while (index_begin > 0) {
            offset = index_begin + 1;
            index_end = ((String)ret).indexOf(" ", index_begin + 1);
            int indexr = ((String)ret).indexOf("\r", index_begin + 1);
            if (indexr > index_begin && indexr < index_end) {
                index_end = indexr;
            }
            if (index_end < 0) {
                index_end = ((String)ret).length() - 1;
            }
            if (index_end > 0) {
                String mret = ((String)ret).substring(0, index_begin) + "<a href='http://" + ((String)ret).substring(index_begin + 5, index_end) + "'>http://" + ((String)ret).substring(index_begin + 5, index_end) + "</a>";
                offset = mret.length();
                ret = mret + ((String)ret).substring(index_end);
            }
            index_begin = ((String)ret).indexOf("http:", offset);
        }
        return ret;
    }
}

