/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx;

import java.util.Arrays;
import org.sonar.api.config.Configuration;
import org.sonar.api.resources.Language;

public class CxxLanguage
implements Language {
    public static final String KEY = "cxx";
    public static final String NAME = "C++";
    public static final String DEFAULT_SOURCE_SUFFIXES = ".cxx,.cpp,.cc,.c";
    public static final String DEFAULT_HEADER_SUFFIXES = ".hxx,.hpp,.hh,.h";
    private final String[] sourceSuffixes;
    private final String[] headerSuffixes;
    private final String[] fileSuffixes;

    public CxxLanguage(Configuration configuration) {
        this.sourceSuffixes = CxxLanguage.createStringArray(configuration.get("sonar.cxx.suffixes.sources").orElse(DEFAULT_SOURCE_SUFFIXES));
        this.headerSuffixes = CxxLanguage.createStringArray(configuration.get("sonar.cxx.suffixes.headers").orElse(DEFAULT_HEADER_SUFFIXES));
        this.fileSuffixes = CxxLanguage.mergeArrays(this.sourceSuffixes, this.headerSuffixes);
    }

    public CxxLanguage() {
        this.sourceSuffixes = CxxLanguage.createStringArray(DEFAULT_SOURCE_SUFFIXES);
        this.headerSuffixes = CxxLanguage.createStringArray(DEFAULT_HEADER_SUFFIXES);
        this.fileSuffixes = CxxLanguage.mergeArrays(this.sourceSuffixes, this.headerSuffixes);
    }

    public String getKey() {
        return KEY;
    }

    public String getName() {
        return NAME;
    }

    public String[] getFileSuffixes() {
        return this.fileSuffixes;
    }

    public String[] getSourceFileSuffixes() {
        return this.sourceSuffixes;
    }

    public String[] getHeaderFileSuffixes() {
        return this.headerSuffixes;
    }

    private static String[] mergeArrays(String[] a, String[] b) {
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private static String[] createStringArray(String commaSeparated) {
        return (String[])Arrays.stream(commaSeparated.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
    }
}

