/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.Plugin;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.plugins.cxx.CxxLanguage;
import org.sonar.plugins.cxx.CxxSonarWayProfile;
import org.sonar.plugins.cxx.coverage.CxxCoverageCache;
import org.sonar.plugins.cxx.coverage.CxxCoverageSensor;
import org.sonar.plugins.cxx.cppdepend.CppDependSensor;
import org.sonar.plugins.cxx.cppdepend.CxxCpdMapping;
import org.sonar.plugins.cxx.cppdepend.CxxMetrics;
import org.sonar.plugins.cxx.cppdepend.NdependRulesDefinition;

public final class CxxPlugin
implements Plugin {
    private static final String CATEGORY = "CppDepend";
    public static final String CPD_IGNORE_LITERALS_KEY = "sonar.cxx.cpd.ignoreLiterals";
    public static final String CPD_IGNORE_IDENTIFIERS_KEY = "sonar.cxx.cpd.ignoreIdentifiers";
    public static final String SOURCE_FILE_SUFFIXES_KEY = "sonar.cxx.suffixes.sources";
    public static final String HEADER_FILE_SUFFIXES_KEY = "sonar.cxx.suffixes.headers";

    private static List<PropertyDefinition> generalProperties() {
        String subcateg = "(1) Rules Definition";
        return new ArrayList<PropertyDefinition>(Arrays.asList(PropertyDefinition.builder((String)"sonar.cppdepend.output").name("Path to the Cppdepend result folder").description("Path to the Cppdepend result folder").category(CATEGORY).onlyOnQualifiers("TRK", new String[]{"BRC"}).build(), PropertyDefinition.builder((String)"sonar.cpp.cppdepend.projectPath").name("Path to the Cppdepend project(cdproj)").description("Path to the Cppdepend project").category(CATEGORY).onlyOnQualifiers("TRK", new String[]{"BRC"}).build(), PropertyDefinition.builder((String)"sonar.cppdepend.scanner").name("CppDepend Scanner").description("CppDepend Scanner path.Must be an absolute path. Example: C:/CppDepend/CppDepend.SonarQubeScanner.exe\"").subCategory(subcateg).onlyOnQualifiers("TRK", new String[]{"BRC"}).index(1).build(), PropertyDefinition.builder((String)"sonar.cppdepend.cdproj").name("C++ Rules").description("cdproj file path to define rules, if no cdproj is defined, the default cppdepend rules will be added to SonarQube.").subCategory(subcateg).onQualifiers("TRK", new String[]{"BRC"}).index(2).build()));
    }

    private static List<PropertyDefinition> languageProperties() {
        return new ArrayList<PropertyDefinition>(Arrays.asList(PropertyDefinition.builder((String)"sonar.cxx.file.suffixes").defaultValue(".cpp,.cxx,.cc,.c,.h,.hpp,.hh,.hxx").name("C/C++ file suffixes").description("Comma-separated list of file suffixes analyzed as C/C++.").subCategory("(2) C/C++ file extensions accepted").onQualifiers("TRK", new String[]{"BRC"}).build()));
    }

    private static List<PropertyDefinition> testingAndCoverageProperties() {
        String subcateg = "(3) Testing & Coverage (As C++ Community Plugin)";
        return new ArrayList<PropertyDefinition>(Arrays.asList(PropertyDefinition.builder((String)"sonar.cxx.coverage.reportPath").name("Unit test coverage report(s)").description("Path to a report containing unit test coverage data, relative to projects root. See <a href='https://github.com/SonarOpenCommunity/sonar-cxx/wiki/Get-code-coverage-metrics'>here</a> for supported formats. Use <a href='https://ant.apache.org/manual/dirtasks.html'>Ant-style wildcards</a> if neccessary.").subCategory(subcateg).onQualifiers("TRK", new String[]{"BRC"}).index(1).build(), PropertyDefinition.builder((String)"sonar.cxx.coverage.itReportPath").name("Integration test coverage report(s)").description("Path to a report containing integration test coverage data, relative to projects root. See <a href='https://github.com/SonarOpenCommunity/sonar-cxx/wiki/Get-code-coverage-metrics'>here</a> for supported formats. Use <a href='https://ant.apache.org/manual/dirtasks.html'>Ant-style wildcards</a> if neccessary.").subCategory(subcateg).onQualifiers("TRK", new String[]{"BRC"}).index(2).build(), PropertyDefinition.builder((String)"sonar.cxx.coverage.overallReportPath").name("Overall test coverage report(s)").description("Path to a report containing overall test coverage data (i.e. test coverage gained by all tests of all kinds), relative to projects root. See <a href='https://github.com/SonarOpenCommunity/sonar-cxx/wiki/Get-code-coverage-metrics'>here</a> for supported formats. Use <a href='https://ant.apache.org/manual/dirtasks.html'>Ant-style wildcards</a> if neccessary.").subCategory(subcateg).onQualifiers("TRK", new String[]{"BRC"}).index(3).build(), PropertyDefinition.builder((String)"sonar.cxx.coverage.forceZeroCoverage").defaultValue("False").name("Enable Force Zero Coverage").description("Set files without coverage reports to zero coverage. Default is 'False'.").subCategory(subcateg).onQualifiers("TRK", new String[]{"BRC"}).type(PropertyType.BOOLEAN).index(4).build()));
    }

    private static List<PropertyDefinition> duplicationsProperties() {
        String subcateg = "(4) Duplications";
        return new ArrayList<PropertyDefinition>(Arrays.asList(PropertyDefinition.builder((String)CPD_IGNORE_LITERALS_KEY).defaultValue("False").name("Ignores literal value differences when evaluating a duplicate block").description("Ignores literal (numbers, characters and strings) value differences when evaluating a duplicate block. This means that e.g. foo=42; and foo=43; will be seen as equivalent. Default is 'False'.").subCategory(subcateg).onQualifiers("TRK", new String[]{"BRC"}).type(PropertyType.BOOLEAN).index(1).build(), PropertyDefinition.builder((String)CPD_IGNORE_IDENTIFIERS_KEY).defaultValue("False").name("Ignores identifier value differences when evaluating a duplicate block").description("Ignores identifier value differences when evaluating a duplicate block e.g. variable names, methods names, and so forth. Default is 'False'.").subCategory(subcateg).onQualifiers("TRK", new String[]{"BRC"}).type(PropertyType.BOOLEAN).index(2).build()));
    }

    public void define(Plugin.Context context) {
        ArrayList<Class> l = new ArrayList<Class>();
        l.add(CxxLanguage.class);
        l.add(CxxSonarWayProfile.class);
        l.add(NdependRulesDefinition.class);
        l.add(CppDependSensor.class);
        l.add(CxxCoverageSensor.class);
        l.add(CxxCoverageAggregator.class);
        l.add(CxxCpdMapping.class);
        l.add(CxxMetrics.class);
        l.addAll(CxxPlugin.generalProperties());
        l.addAll(CxxPlugin.languageProperties());
        l.addAll(CxxPlugin.testingAndCoverageProperties());
        l.addAll(CxxPlugin.duplicationsProperties());
        context.addExtensions(l);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class CxxCoverageAggregator
    extends CxxCoverageCache {
    }
}

