/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.coverage;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.cxx.coverage.CoverageMeasures;
import org.sonar.plugins.cxx.coverage.CxxCoverageParser;
import org.sonar.plugins.cxx.utils.StaxParser;

public class BullseyeParser
extends CxxCoverageParser {
    public static final Logger LOG = Loggers.get(BullseyeParser.class);
    private String prevLine;
    private int totaldecisions;
    private int totalcovereddecisions;
    private int totalconditions;
    private int totalcoveredconditions;

    @Override
    public void processReport(SensorContext context, File report, final Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        LOG.debug("Parsing 'Bullseye' format");
        StaxParser topLevelparser = new StaxParser(new StaxParser.XmlStreamHandler(){

            @Override
            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                rootCursor.advance();
                BullseyeParser.this.collectCoverageLeafNodes(rootCursor.getAttrValue("dir"), rootCursor.childElementCursor("src"), coverageData);
            }
        });
        StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

            @Override
            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                rootCursor.advance();
                BullseyeParser.this.collectCoverage2(rootCursor.getAttrValue("dir"), rootCursor.childElementCursor("folder"), coverageData);
            }
        });
        topLevelparser.parse(report);
        parser.parse(report);
        boolean a = true;
    }

    private void collectCoverageLeafNodes(String refPath, SMInputCursor folder, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        refPath = this.ensureRefPathIsCorrect(refPath);
        while (folder.getNext() != null) {
            File fileName = new File(refPath, folder.getAttrValue("name"));
            this.recTreeTopWalk(fileName, folder, coverageData);
        }
    }

    private void recTreeTopWalk(File fileName, SMInputCursor folder, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        SMInputCursor child = folder.childElementCursor();
        while (child.getNext() != null) {
            CoverageMeasures fileMeasuresBuilderIn = CoverageMeasures.create();
            this.funcWalk(child, fileMeasuresBuilderIn);
            coverageData.put(fileName.getPath(), fileMeasuresBuilderIn);
        }
    }

    private void collectCoverage2(String refPath, SMInputCursor folder, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        refPath = this.ensureRefPathIsCorrect(refPath);
        LinkedList<String> path = new LinkedList<String>();
        while (folder.getNext() != null) {
            String folderName = folder.getAttrValue("name");
            path.add(folderName);
            this.recTreeWalk(refPath, folder, path, coverageData);
            path.removeLast();
        }
    }

    private void probWalk(SMInputCursor prob, CoverageMeasures fileMeasuresBuilderIn) throws XMLStreamException {
        String line = prob.getAttrValue("line");
        String kind = prob.getAttrValue("kind");
        String event = prob.getAttrValue("event");
        if (!line.equals(this.prevLine)) {
            this.saveConditions(fileMeasuresBuilderIn);
        }
        this.updateMeasures(kind, event, line, fileMeasuresBuilderIn);
        this.prevLine = line;
    }

    private void funcWalk(SMInputCursor func, CoverageMeasures fileMeasuresBuilderIn) throws XMLStreamException {
        SMInputCursor prob = func.childElementCursor();
        while (prob.getNext() != null) {
            this.probWalk(prob, fileMeasuresBuilderIn);
        }
        this.saveConditions(fileMeasuresBuilderIn);
    }

    private void fileWalk(SMInputCursor file, CoverageMeasures fileMeasuresBuilderIn) throws XMLStreamException {
        SMInputCursor func = file.childElementCursor();
        while (func.getNext() != null) {
            this.funcWalk(func, fileMeasuresBuilderIn);
        }
    }

    private void recTreeWalk(String refPath, SMInputCursor folder, List<String> path, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        refPath = this.ensureRefPathIsCorrect(refPath);
        SMInputCursor child = folder.childElementCursor();
        while (child.getNext() != null) {
            String folderChildName = child.getLocalName();
            String name = child.getAttrValue("name");
            path.add(name);
            if ("src".equalsIgnoreCase(folderChildName)) {
                Object fileName = "";
                Iterator<String> iterator = path.iterator();
                while (iterator.hasNext()) {
                    fileName = (String)fileName + iterator.next() + File.separator;
                }
                if (new File((String)(fileName = ((String)fileName).substring(0, ((String)fileName).length() - 1))).isAbsolute()) {
                    refPath = "";
                }
                CoverageMeasures fileMeasuresBuilderIn = CoverageMeasures.create();
                this.fileWalk(child, fileMeasuresBuilderIn);
                coverageData.put(refPath + (String)fileName, fileMeasuresBuilderIn);
            } else {
                this.recTreeWalk(refPath, child, path, coverageData);
            }
            path.remove(path.size() - 1);
        }
    }

    private void saveConditions(CoverageMeasures fileMeasuresBuilderIn) {
        if (this.totaldecisions > 0 || this.totalconditions > 0) {
            if (this.totalcovereddecisions == 0 && this.totalcoveredconditions == 0) {
                fileMeasuresBuilderIn.setHits(Integer.parseInt(this.prevLine), 0);
            } else {
                fileMeasuresBuilderIn.setHits(Integer.parseInt(this.prevLine), 1);
            }
            if (this.totalconditions > 0) {
                fileMeasuresBuilderIn.setConditions(Integer.parseInt(this.prevLine), this.totalconditions, this.totalcoveredconditions);
            } else {
                fileMeasuresBuilderIn.setConditions(Integer.parseInt(this.prevLine), 2, this.totalcovereddecisions);
            }
        }
        this.totaldecisions = 0;
        this.totalcovereddecisions = 0;
        this.totalconditions = 0;
        this.totalcoveredconditions = 0;
    }

    private void updateMeasures(String kind, String event, String line, CoverageMeasures fileMeasuresBuilderIn) {
        if ("decision".equalsIgnoreCase(kind) || "condition".equalsIgnoreCase(kind)) {
            if ("condition".equalsIgnoreCase(kind)) {
                this.totalconditions += 2;
                ++this.totalcoveredconditions;
                if ("full".equalsIgnoreCase(event)) {
                    ++this.totalcoveredconditions;
                }
                if ("none".equalsIgnoreCase(event)) {
                    --this.totalcoveredconditions;
                }
            } else {
                ++this.totaldecisions;
                this.totalcovereddecisions = 1;
                if ("full".equalsIgnoreCase(event)) {
                    this.totalcovereddecisions = 2;
                }
                if ("none".equalsIgnoreCase(event)) {
                    this.totalcovereddecisions = 0;
                }
            }
        } else if ("full".equalsIgnoreCase(event)) {
            fileMeasuresBuilderIn.setHits(Integer.parseInt(line), 1);
        } else {
            fileMeasuresBuilderIn.setHits(Integer.parseInt(line), 0);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private String ensureRefPathIsCorrect(String refPath) {
        if (refPath == null || refPath.isEmpty() || refPath.endsWith(File.separator)) {
            return refPath;
        }
        return refPath + File.separatorChar;
    }
}

