/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.coverage;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.cxx.coverage.CoverageMeasures;
import org.sonar.plugins.cxx.coverage.CxxCoverageParser;
import org.sonar.plugins.cxx.utils.CxxUtils;
import org.sonar.plugins.cxx.utils.StaxParser;

public class CoberturaParser
extends CxxCoverageParser {
    public static final Logger LOG = Loggers.get(CoberturaParser.class);

    @Override
    public void processReport(final SensorContext context, File report, final Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        LOG.debug("Parsing 'Cobertura' format");
        StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

            @Override
            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                rootCursor.advance();
                CoberturaParser.this.collectPackageMeasures(context, rootCursor.descendantElementCursor("package"), coverageData);
            }
        });
        parser.parse(report);
    }

    private void collectPackageMeasures(SensorContext context, SMInputCursor pack, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        while (pack.getNext() != null) {
            this.collectFileMeasures(context, pack.descendantElementCursor("class"), coverageData);
        }
    }

    private void collectFileMeasures(SensorContext context, SMInputCursor clazz, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        while (clazz.getNext() != null) {
            String normalPath = CxxUtils.normalizePathFull(clazz.getAttrValue("filename"), context.fileSystem().baseDir().getAbsolutePath());
            if (normalPath == null) continue;
            CoverageMeasures builder = coverageData.get(normalPath);
            if (builder == null) {
                builder = CoverageMeasures.create();
                coverageData.put(normalPath, builder);
            }
            this.collectFileData(clazz, builder);
        }
    }

    private void collectFileData(SMInputCursor clazz, CoverageMeasures builder) throws XMLStreamException {
        SMInputCursor line = clazz.childElementCursor("lines").advance().childElementCursor("line");
        while (line.getNext() != null) {
            Pattern p;
            Matcher m;
            int lineId = Integer.parseInt(line.getAttrValue("number"));
            long noHits = Long.parseLong(line.getAttrValue("hits"));
            if (noHits > Integer.MAX_VALUE) {
                LOG.warn("Truncating the actual number of hits ({}) to the maximum number supported by Sonar ({})", (Object)noHits, (Object)Integer.MAX_VALUE);
                noHits = Integer.MAX_VALUE;
            }
            builder.setHits(lineId, (int)noHits);
            String isBranch = line.getAttrValue("branch");
            String text = line.getAttrValue("condition-coverage");
            if (text == null || !"true".equals(isBranch) || text.trim().isEmpty() || !(m = (p = Pattern.compile("\\((.*?)\\)")).matcher(text)).find()) continue;
            String[] conditions = m.group(1).split("/");
            builder.setConditions(lineId, Integer.parseInt(conditions[1]), Integer.parseInt(conditions[0]));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

