/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.coverage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sonar.plugins.cxx.coverage.CoverageMeasure;

class CoverageMeasures {
    private final Map<Integer, CoverageMeasure> measuresLines = new HashMap<Integer, CoverageMeasure>();
    private final Map<Integer, CoverageMeasure> measuresConditions = new HashMap<Integer, CoverageMeasure>();

    private CoverageMeasures() {
    }

    static CoverageMeasures create() {
        CoverageMeasures measures = new CoverageMeasures();
        return measures;
    }

    void setHits(int lineId, int i) {
        if (this.measuresLines.containsKey(lineId)) {
            CoverageMeasure existentData = this.measuresLines.get(lineId);
            existentData.setHits(lineId, i);
        } else {
            CoverageMeasure newLineHit = new CoverageMeasure(CoverageMeasure.CoverageType.LINE, lineId);
            newLineHit.setHits(lineId, i);
            this.measuresLines.put(lineId, newLineHit);
        }
    }

    void setConditions(int lineId, int totalConditions, int coveredConditions) {
        if (this.measuresConditions.containsKey(lineId)) {
            CoverageMeasure existentData = this.measuresLines.get(lineId);
            existentData.setConditions(totalConditions, coveredConditions);
        } else {
            CoverageMeasure newLineHit = new CoverageMeasure(CoverageMeasure.CoverageType.CONDITION, lineId);
            newLineHit.setConditions(totalConditions, coveredConditions);
            this.measuresConditions.put(lineId, newLineHit);
        }
    }

    Collection<CoverageMeasure> getCoverageMeasures() {
        HashMap<Integer, CoverageMeasure> measures = new HashMap<Integer, CoverageMeasure>();
        measures.putAll(this.measuresLines);
        measures.putAll(this.measuresConditions);
        return measures.values();
    }
}

