/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.coverage;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.cxx.coverage.BullseyeParser;
import org.sonar.plugins.cxx.coverage.CoberturaParser;
import org.sonar.plugins.cxx.coverage.CoverageMeasures;
import org.sonar.plugins.cxx.coverage.CoverageParser;
import org.sonar.plugins.cxx.coverage.VisualStudioParser;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;

public class CxxCoverageSensor
extends CxxReportSensor {
    public static final Logger LOG = Loggers.get(CxxCoverageSensor.class);
    public static final String REPORT_PATH_KEY = "sonar.cxx.coverage.reportPath";
    public static final String IT_REPORT_PATH_KEY = "sonar.cxx.coverage.itReportPath";
    public static final String OVERALL_REPORT_PATH_KEY = "sonar.cxx.coverage.overallReportPath";
    public static final String FORCE_ZERO_COVERAGE_KEY = "sonar.cxx.coverage.forceZeroCoverage";
    private static final Map<String, Map<String, CoverageMeasures>> CACHE_UNIT = new HashMap<String, Map<String, CoverageMeasures>>();
    private static final Map<String, Map<String, CoverageMeasures>> CACHE_IT = new HashMap<String, Map<String, CoverageMeasures>>();
    private static final Map<String, Map<String, CoverageMeasures>> CACHE_OVERALL = new HashMap<String, Map<String, CoverageMeasures>>();
    private final List<CoverageParser> parsers = new LinkedList<CoverageParser>();

    public CxxCoverageSensor(Configuration settings) {
        super(settings, null);
        this.parsers.add(new CoberturaParser());
        this.parsers.add(new BullseyeParser());
        this.parsers.add(new VisualStudioParser());
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("cxx").name("CxxCoverageSensor");
    }

    public void execute(SensorContext context, Map<InputFile, Set<Integer>> linesOfCode) {
        Map<String, CoverageMeasures> coverageMeasures = null;
        Map<String, CoverageMeasures> itCoverageMeasures = null;
        Map<String, CoverageMeasures> overallCoverageMeasures = null;
        LOG.debug("Coverage BaseDir '{}' ", (Object)context.fileSystem().baseDir());
        LOG.debug("Zeroing coverage information for untouched files");
        this.zeroMeasuresWithoutReports(context, coverageMeasures, itCoverageMeasures, overallCoverageMeasures, linesOfCode);
    }

    private Map<String, Map<String, CoverageMeasures>> unitCoverageCache() {
        return CACHE_UNIT;
    }

    private Map<String, Map<String, CoverageMeasures>> integrationCoverageCache() {
        return CACHE_IT;
    }

    private Map<String, Map<String, CoverageMeasures>> overallCoverageCache() {
        return CACHE_OVERALL;
    }

    private void zeroMeasuresWithoutReports(SensorContext context, Map<String, CoverageMeasures> coverageMeasures, Map<String, CoverageMeasures> itCoverageMeasures, Map<String, CoverageMeasures> overallCoverageMeasures, Map<InputFile, Set<Integer>> linesOfCode) {
        FileSystem fileSystem = context.fileSystem();
        FilePredicates p = fileSystem.predicates();
        Iterable inputFiles = fileSystem.inputFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("cxx")));
        for (InputFile inputFile : inputFiles) {
            Set<Integer> linesOfCodeForFile = linesOfCode.get(inputFile);
            String string = CxxUtils.normalizePath(inputFile.absolutePath());
        }
    }

    private Map<String, CoverageMeasures> processReports(SensorContext context, List<File> reports, Map<String, Map<String, CoverageMeasures>> cacheCov) {
        HashMap<String, CoverageMeasures> measuresTotal = new HashMap<String, CoverageMeasures>();
        HashMap<String, CoverageMeasures> measuresForReport = new HashMap<String, CoverageMeasures>();
        for (File report : reports) {
            if (!cacheCov.containsKey(report.getAbsolutePath())) {
                boolean parsed = false;
                for (CoverageParser parser : this.parsers) {
                    try {
                        measuresForReport.clear();
                        parser.processReport(context, report, measuresForReport);
                        if (measuresForReport.isEmpty()) continue;
                        parsed = true;
                        measuresTotal.putAll(measuresForReport);
                        LOG.info("Added report '{}' (parsed by: {}) to the coverage data", (Object)report, (Object)parser);
                        break;
                    }
                    catch (XMLStreamException e) {
                        LOG.trace("Report {} cannot be parsed by {}", (Object)report, (Object)parser);
                    }
                }
                if (!parsed) {
                    LOG.error("Report {} cannot be parsed", (Object)report);
                }
                LOG.debug("cached measures for '{}' : current cache content data = '{}'", (Object)report.getAbsolutePath(), (Object)cacheCov.size());
                cacheCov.put(report.getAbsolutePath(), measuresTotal);
                continue;
            }
            LOG.debug("Processing report '{}' skipped - already in cache", (Object)report);
            measuresTotal.putAll(cacheCov.get(report.getAbsolutePath()));
        }
        return measuresTotal;
    }
}

