/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.coverage;

import java.io.File;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.cxx.coverage.CoverageMeasures;
import org.sonar.plugins.cxx.coverage.CxxCoverageParser;
import org.sonar.plugins.cxx.utils.StaxParser;

public class VisualStudioParser
extends CxxCoverageParser {
    public static final Logger LOG = Loggers.get(VisualStudioParser.class);

    @Override
    public void processReport(SensorContext context, File report, final Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        LOG.debug("Parsing 'Visual Studio' format");
        StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

            @Override
            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                rootCursor.advance();
                VisualStudioParser.this.collectModuleMeasures(rootCursor.descendantElementCursor("module"), coverageData);
            }
        });
        parser.parse(report);
    }

    private void collectModuleMeasures(SMInputCursor module, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        while (module.getNext() != null) {
            this.handleModuleItems(module, coverageData);
        }
    }

    private void handleModuleItems(SMInputCursor module, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        SMInputCursor child = module.childElementCursor();
        while (child.getNext() != null) {
            String name = child.getLocalName();
            if ("functions".equalsIgnoreCase(name)) {
                this.collectFunctionMeasures(child, coverageData);
                continue;
            }
            if (!"source_files".equalsIgnoreCase(name)) continue;
            this.collectSourceFileMeasures(child, coverageData);
        }
    }

    private void collectSourceFileMeasures(SMInputCursor sourceFiles, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        SMInputCursor sourceFile = sourceFiles.childElementCursor("source_file");
        while (sourceFile.getNext() != null) {
            String id = sourceFile.getAttrValue("id");
            CoverageMeasures builder = coverageData.remove(id);
            coverageData.put(sourceFile.getAttrValue("path"), builder);
        }
    }

    private void collectFunctionMeasures(SMInputCursor functions, Map<String, CoverageMeasures> coverageData) throws XMLStreamException {
        SMInputCursor function = functions.childElementCursor("function");
        while (function.getNext() != null) {
            int blocksCovered = Integer.parseInt(function.getAttrValue("blocks_covered"));
            int blocksNotCovered = Integer.parseInt(function.getAttrValue("blocks_not_covered"));
            this.collectRangeMeasures(function, coverageData, blocksCovered + blocksNotCovered, blocksCovered);
        }
    }

    private void collectRangeMeasures(SMInputCursor function, Map<String, CoverageMeasures> coverageData, int conditions, int coveredConditions) throws XMLStreamException {
        SMInputCursor range = function.childElementCursor("ranges").advance().childElementCursor("range");
        CoverageMeasures builder = null;
        String lastSourceId = "";
        while (range.getNext() != null) {
            int covered;
            String sourceId = range.getAttrValue("source_id");
            int startLine = Integer.parseInt(range.getAttrValue("start_line"));
            int endLine = Integer.parseInt(range.getAttrValue("end_line"));
            int n = covered = !"no".equalsIgnoreCase(range.getAttrValue("covered")) ? 1 : 0;
            if (!sourceId.equals(lastSourceId) || builder == null) {
                builder = coverageData.get(sourceId);
                if (builder == null) {
                    builder = CoverageMeasures.create();
                    coverageData.put(sourceId, builder);
                }
                builder.setConditions(startLine - 1, conditions, coveredConditions);
                lastSourceId = sourceId;
            }
            while (startLine <= endLine) {
                builder.setHits(startLine, covered);
                ++startLine;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

