/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.cxx.cppdepend.CppDependMetric;
import org.sonar.plugins.cxx.cppdepend.CppDependResultParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CppDependMetricParser {
    private final Document doc;
    private final XPath xpath;
    private static final Logger LOG = LoggerFactory.getLogger(CppDependResultParser.class);

    CppDependMetricParser(Document doc) {
        this.doc = doc;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public static CppDependMetricParser fromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new CppDependMetricParser(factory.newDocumentBuilder().parse(file));
    }

    NodeList getMetrics() throws XPathExpressionException {
        return (NodeList)this.xpath.compile("//Metric").evaluate(this.doc, XPathConstants.NODESET);
    }

    public List<CppDependMetric> parse() throws XPathExpressionException {
        ArrayList<CppDependMetric> ret = new ArrayList<CppDependMetric>();
        NodeList metrics = this.getMetrics();
        for (int j = 0; j < metrics.getLength(); ++j) {
            Element row = (Element)metrics.item(j);
            String Name = row.getAttribute("Name");
            double value = Double.parseDouble(row.getAttribute("Value"));
            CppDependMetric metric = new CppDependMetric();
            metric.Name = Name;
            metric.Value = value;
            ret.add(metric);
        }
        return ret;
    }
}

