/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.cxx.cppdepend.CppDependIssue;
import org.sonar.plugins.cxx.cppdepend.CppDependQueryResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CppDependResultParser {
    private final Document doc;
    private final XPath xpath;
    private final ImmutableList.Builder<CppDependIssue> issueBuilder;
    private static final Logger LOG = LoggerFactory.getLogger(CppDependResultParser.class);

    CppDependResultParser(Document doc) {
        this.doc = doc;
        this.xpath = XPathFactory.newInstance().newXPath();
        this.issueBuilder = ImmutableList.builder();
    }

    public static CppDependResultParser fromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new CppDependResultParser(factory.newDocumentBuilder().parse(file));
    }

    NodeList getIssues() throws XPathExpressionException {
        return (NodeList)this.xpath.compile("/Projects/Project/Issues/Issue").evaluate(this.doc, XPathConstants.NODESET);
    }

    public CppDependQueryResult parse() throws XPathExpressionException {
        CppDependQueryResult ret = new CppDependQueryResult();
        NodeList issues = this.getIssues();
        for (int j = 0; j < issues.getLength(); ++j) {
            Element row = (Element)issues.item(j);
            String filePath = row.getAttribute("Path");
            File file = new File(filePath);
            if (!file.exists()) continue;
            String ruleKey = StringEscapeUtils.escapeXml((String)row.getAttribute("Name").replace(" ", "").replace(",", ""));
            String ruleDesc = row.getAttribute("Name");
            int fileLine = Integer.parseInt(row.getAttribute("Line"));
            int debt = Integer.parseInt(row.getAttribute("Debt"));
            String severity = row.getAttribute("Severity");
            this.issueBuilder.add((Object)new CppDependIssue(ruleKey, ruleDesc, file, fileLine, debt, severity));
        }
        ret.issues = this.issueBuilder.build();
        return ret;
    }
}

