/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.cxx.cppdepend.CppDependFileMetric;
import org.sonar.plugins.cxx.cppdepend.CppDependIssue;
import org.sonar.plugins.cxx.cppdepend.CppDependProjectParser;
import org.sonar.plugins.cxx.cppdepend.CppDependQueryResult;
import org.sonar.plugins.cxx.cppdepend.CppDependResultParser;
import org.sonar.plugins.cxx.cppdepend.NDependExecutor;
import org.sonar.plugins.cxx.cppdepend.SonarResultParser;
import org.xml.sax.SAXException;

public final class CppDependSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(CppDependSensor.class);
    private final FileSystem fileSystem;
    private final Configuration configuration;
    private final ActiveRules rules;
    private static Boolean analysisDone = Boolean.FALSE;

    public CppDependSensor(Configuration configuration, FileSystem fileSystem, CheckFactory checkFactory, ActiveRules rules) {
        this.configuration = configuration;
        this.fileSystem = fileSystem;
        this.rules = rules;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("cxx").name("CppDependSensor");
    }

    public void execute(SensorContext context) {
        String projectPath = this.configuration.get("sonar.cpp.cppdepend.projectPath").orElse(null);
        if (projectPath == null) {
            LOG.info("CppDepend analysis skipped: 'sonar.cpp.cppdepend.projectPath' not set");
            return;
        }
        File projectFile = new File(projectPath);
        if (!projectFile.exists()) {
            LOG.info("CppDepend analysis skipped: project file does not exist: {}", (Object)projectFile);
            return;
        }
        String scannerPath = this.configuration.get("sonar.cppdepend.scanner").orElse(null);
        if (scannerPath == null) {
            LOG.error("CppDepend analysis skipped: 'sonar.cppdepend.scanner' not set");
            return;
        }
        File scannerFile = new File(scannerPath);
        if (!scannerFile.exists()) {
            LOG.error("CppDepend analysis skipped: scanner path is invalid: {}", (Object)scannerFile);
            return;
        }
        try {
            if (!analysisDone.booleanValue()) {
                NDependExecutor executor = new NDependExecutor();
                File outputDir = new File(CppDependProjectParser.fromFile(projectFile).parse());
                File allMetricsFile = new File(outputDir, "allmetrics.xml");
                File issuesFile = new File(outputDir, "issues.xml");
                executor.execute(scannerPath, projectPath, allMetricsFile, issuesFile);
                this.loadMetrics(new File(outputDir, "allmetrics.xml"), context);
                this.analyzeResults(issuesFile, context);
                analysisDone = Boolean.TRUE;
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            LOG.error("CppDepend analysis failed", (Throwable)e);
        }
    }

    private void loadMetrics(File metricsFile, SensorContext context) {
        try {
            for (CppDependFileMetric file : SonarResultParser.fromFile(metricsFile).parse()) {
                File ioFile = new File(file.Path);
                InputFile inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(ioFile));
                if (inputFile == null) continue;
                this.saveMeasures(inputFile, file, context);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load CppDepend metrics", (Throwable)e);
        }
    }

    private void saveMeasures(InputFile inputFile, CppDependFileMetric fileMetric, SensorContext context) {
        context.newMeasure().forMetric((Metric)CoreMetrics.FILES).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMetric.Files)).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.NCLOC).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMetric.NLoc)).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.STATEMENTS).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMetric.PLoc)).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.FUNCTIONS).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMetric.NBMethods)).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.CLASSES).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMetric.NBClasses)).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.COMPLEXITY).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMetric.CC)).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.COMMENT_LINES).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMetric.Comments)).save();
    }

    private void analyzeResults(File issuesFile, SensorContext context) {
        try {
            CppDependQueryResult result = CppDependResultParser.fromFile(issuesFile).parse();
            for (CppDependIssue issue : result.issues) {
                InputFile inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(issue.getFile().getCanonicalFile()));
                if (inputFile == null) continue;
                RuleKey ruleKey = RuleKey.of((String)"cpp-cppdepend", (String)issue.getRuleKey());
                NewIssue newIssue = context.newIssue().forRule(ruleKey);
                NewIssueLocation location = newIssue.newLocation().on((InputComponent)inputFile).at(inputFile.selectLine(issue.getLine())).message(issue.getMessage());
                newIssue.at(location);
                switch (issue.getSeverity()) {
                    case "Blocker": {
                        newIssue.overrideSeverity(Severity.BLOCKER);
                        break;
                    }
                    case "Critical": {
                        newIssue.overrideSeverity(Severity.CRITICAL);
                        break;
                    }
                    case "High": {
                        newIssue.overrideSeverity(Severity.MAJOR);
                        break;
                    }
                    case "Medium": {
                        newIssue.overrideSeverity(Severity.MINOR);
                        break;
                    }
                    case "Low": {
                        newIssue.overrideSeverity(Severity.INFO);
                    }
                }
                newIssue.gap(Double.valueOf(issue.getDebt()));
                newIssue.save();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to analyze CppDepend issues", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

