/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import java.io.File;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.cxx.api.CxxTokenType;
import org.sonar.squidbridge.SquidAstVisitor;

public class CxxCpdVisitor
extends SquidAstVisitor<Grammar>
implements AstAndTokenVisitor {
    private static final Logger LOG = Loggers.get(CxxCpdVisitor.class);
    private final SensorContext sensorContext;
    private final Boolean ignoreLiterals;
    private final Boolean ignoreIdentifiers;
    private InputFile inputFile;
    private NewCpdTokens cpdTokens;

    public CxxCpdVisitor(SensorContext sensorContext, Boolean ignoreLiterals, Boolean ignoreIdentifiers) {
        this.sensorContext = sensorContext;
        this.ignoreLiterals = ignoreLiterals;
        this.ignoreIdentifiers = ignoreIdentifiers;
    }

    public void visitFile(@Nullable AstNode astNode) {
        File file = this.getContext().getFile();
        this.inputFile = this.sensorContext.fileSystem().inputFile(this.sensorContext.fileSystem().predicates().is(file));
        this.cpdTokens = this.sensorContext.newCpdTokens().onFile(this.inputFile);
    }

    public void leaveFile(@Nullable AstNode astNode) {
        this.cpdTokens.save();
    }

    public void visitToken(Token token) {
        if (!token.isGeneratedCode()) {
            String text;
            if (this.ignoreIdentifiers.booleanValue() && token.getType().equals((Object)GenericTokenType.IDENTIFIER)) {
                text = "_I";
            } else if (this.ignoreLiterals.booleanValue() && token.getType().equals((Object)CxxTokenType.NUMBER)) {
                text = "_N";
            } else if (this.ignoreLiterals.booleanValue() && token.getType().equals((Object)CxxTokenType.STRING)) {
                text = "_S";
            } else if (this.ignoreLiterals.booleanValue() && token.getType().equals((Object)CxxTokenType.CHARACTER)) {
                text = "_C";
            } else {
                if (token.getType().equals((Object)GenericTokenType.EOF)) {
                    return;
                }
                text = token.getValue();
            }
            try {
                TextRange range = this.inputFile.newRange(token.getLine(), token.getColumn(), token.getLine(), token.getColumn() + token.getValue().length());
                this.cpdTokens.addToken(range, text);
            }
            catch (Exception e) {
                LOG.debug("CPD error in file '{}' at line:{}, column:{}", new Object[]{this.getContext().getFile().getAbsoluteFile(), token.getLine(), token.getColumn()});
            }
        }
    }
}

