/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;
import org.sonar.plugins.cxx.cppdepend.RulesCreator;

public class NdependRulesDefinition
implements RulesDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(NdependRulesDefinition.class);
    public static final String RULES_RESOURCE = "/org/sonar/plugins/cppdepend/rules.xml";
    private final RulesDefinitionXmlLoader xmlLoader;
    private final Configuration configuration;

    public NdependRulesDefinition(RulesDefinitionXmlLoader xmlLoader, Configuration configuration) {
        this.xmlLoader = xmlLoader;
        this.configuration = configuration;
    }

    public void define(RulesDefinition.Context context) {
        LOG.info("Defining rules for CppDepend...");
        RulesDefinition.NewRepository repository = context.createRepository("cpp-cppdepend", "cxx");
        repository.setName("CppDepend - cpp");
        try {
            File f;
            String rulesPath = this.configuration.get("sonar.cppdepend.cdproj").orElse("");
            if (!rulesPath.isEmpty() && (f = new File(rulesPath)).exists() && f.isFile()) {
                String rules = RulesCreator.fromFile(f).parse();
                ByteArrayInputStream stream = new ByteArrayInputStream(rules.getBytes(Charsets.UTF_8));
                this.xmlLoader.load(repository, (Reader)new InputStreamReader((InputStream)stream, Charsets.UTF_8));
                repository.done();
                return;
            }
            InputStream xmlStream = this.getClass().getResourceAsStream("/Template.cdproj");
            if (xmlStream != null) {
                String rules = RulesCreator.fromFile(xmlStream).parse();
                ByteArrayInputStream stream = new ByteArrayInputStream(rules.getBytes(Charsets.UTF_8));
                this.xmlLoader.load(repository, (Reader)new InputStreamReader((InputStream)stream, Charsets.UTF_8));
                repository.done();
            } else {
                LOG.error("Default Template.cdproj not found in resources!");
            }
        }
        catch (IOException e) {
            LOG.error("Failed to retrieve rules: please check that you defined the sonar.cppdepend.cdproj variable", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve rules: unexpected exception", (Throwable)e);
        }
    }
}

