/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.plugins.cxx.cppdepend.RulesCreator;
import org.xml.sax.SAXException;

public class NdependRulesFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(NdependRulesFetcher.class);
    private final Configuration configuration;
    private byte[] rules;

    public NdependRulesFetcher(Configuration configuration) {
        this.configuration = configuration;
        this.rules = null;
    }

    private boolean needsFetch() {
        return this.rules == null;
    }

    public InputStream get() throws IOException {
        if (this.needsFetch()) {
            this.rules = this.fetch();
        }
        return new ByteArrayInputStream(this.rules);
    }

    private byte[] fetch() throws IOException {
        InputStream in = null;
        String rulesPath = this.configuration.get("sonar.cppdepend.cdproj").orElse(null);
        if (rulesPath != null && !rulesPath.trim().isEmpty()) {
            File rulesFile = new File(rulesPath);
            if (rulesFile.exists() && !rulesFile.isDirectory()) {
                try {
                    String rulesContent = RulesCreator.fromFile(rulesFile).parse();
                    in = new ByteArrayInputStream(rulesContent.getBytes(Charsets.UTF_8));
                    LOG.info("Loaded rules from '{}'", (Object)rulesFile.getAbsolutePath());
                }
                catch (ParserConfigurationException | XPathExpressionException | SAXException e) {
                    LOG.error("Failed to parse rules from '{}'", (Object)rulesFile.getAbsolutePath(), (Object)e);
                    throw new IOException("Cannot parse rules file", e);
                }
            } else {
                LOG.warn("Configured rules file '{}' does not exist, using default rules", (Object)rulesPath);
            }
        }
        if (in == null) {
            LOG.info("Using default rules from resource '{}'", (Object)"/org/sonar/plugins/cppdepend/rules.xml");
            in = this.getClass().getResourceAsStream("/org/sonar/plugins/cppdepend/rules.xml");
        }
        return IOUtils.toByteArray(in);
    }
}

