/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.cxx.cppdepend.CppDependFileMetric;
import org.sonar.plugins.cxx.cppdepend.CppDependResultParser;
import org.sonar.plugins.cxx.cppdepend.ProjectMetrics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectResultParser {
    private final Document doc;
    private final XPath xpath;
    private final ImmutableList.Builder<CppDependFileMetric> fileBuilder;
    private static final Logger LOG = LoggerFactory.getLogger(CppDependResultParser.class);

    ProjectResultParser(Document doc) {
        this.doc = doc;
        this.xpath = XPathFactory.newInstance().newXPath();
        this.fileBuilder = ImmutableList.builder();
    }

    public static ProjectResultParser fromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new ProjectResultParser(factory.newDocumentBuilder().parse(file));
    }

    @VisibleForTesting
    NodeList getQueries(String projectName) throws XPathExpressionException {
        return (NodeList)this.xpath.compile("/Projects/Project[@name='" + projectName + "']").evaluate(this.doc, XPathConstants.NODESET);
    }

    NodeList getClasses(Node queryNode) throws XPathExpressionException {
        return (NodeList)this.xpath.compile("Class").evaluate(queryNode, XPathConstants.NODESET);
    }

    public ProjectMetrics parse(String projectName) throws XPathExpressionException {
        NodeList queries = this.getQueries(projectName);
        ProjectMetrics pm = new ProjectMetrics();
        StringBuilder json = new StringBuilder(" [ ");
        for (int i = 0; i < queries.getLength(); ++i) {
            Node query = queries.item(i);
            NodeList rows = this.getClasses(queries.item(i));
            String path = ((Element)query).getAttribute("path");
            pm.Abstractness = Float.parseFloat(((Element)query).getAttribute("Abstractness").replace(',', '.'));
            pm.Instability = Float.parseFloat(((Element)query).getAttribute("Instability").replace(',', '.'));
            pm.ac = Integer.parseInt(((Element)query).getAttribute("ac"));
            pm.ec = Integer.parseInt(((Element)query).getAttribute("ec"));
            pm.dist = Float.parseFloat(((Element)query).getAttribute("dist").replace(',', '.'));
            pm.ndist = Float.parseFloat(((Element)query).getAttribute("ndist").replace(',', '.'));
            pm.rc = Float.parseFloat(((Element)query).getAttribute("RC").replace(',', '.'));
            pm.nbnamespaces = Integer.parseInt(((Element)query).getAttribute("nbnspc"));
            for (int j = 0; j < rows.getLength(); ++j) {
                Element row = (Element)rows.item(j);
                if (row.getAttribute("name").equals("__Globals")) continue;
                json.append(" {");
                json.append("\"name\":\"").append(row.getAttribute("name")).append("\",");
                json.append("\"CC\":\"").append(row.getAttribute("CC").replace(",", ".")).append("\",");
                json.append("\"LCOM\":\"").append(row.getAttribute("LCOM").replace(",", ".")).append("\",");
                json.append("\"LCOMHS\":\"").append(row.getAttribute("LCOMHS").replace(",", ".")).append("\",");
                json.append("\"NbFields\":").append(row.getAttribute("NbFields")).append(",");
                json.append("\"NbMethods\":").append(row.getAttribute("NbMethods")).append(",");
                json.append("\"Level\":").append(row.getAttribute("Level")).append(",");
                json.append("\"Rank\":").append(row.getAttribute("Rank").replace(",", ".")).append(",");
                json.append("\"DIT\":").append(row.getAttribute("DIT")).append(",");
                json.append("\"ac\":").append(row.getAttribute("ac")).append(",");
                json.append("\"ec\":").append(row.getAttribute("ec"));
                json.append("}");
                if (j >= rows.getLength() - 1) continue;
                json.append(",");
            }
            json.append("]\n");
            LOG.debug(json.toString());
            pm.json = json.toString();
        }
        return pm;
    }
}

