/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import com.google.common.collect.ImmutableList;
import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.plugins.cxx.cppdepend.CppDependQuery;

public class QueryLoader {
    public ImmutableList<CppDependQuery> getQueries(Reader reader) {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        SMInputFactory inputFactory = new SMInputFactory(xmlFactory);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        try {
            SMHierarchicCursor root = inputFactory.rootElementCursor(reader);
            root.advance();
            SMInputCursor rules = root.childElementCursor("rule");
            while (rules.getNext() != null) {
                builder.add((Object)this.processRule(rules));
            }
            return builder.build();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
    }

    private CppDependQuery processRule(SMInputCursor rule) throws XMLStreamException {
        String key = null;
        String group = null;
        CppDependQuery.Scope scope = null;
        String code = null;
        int line = rule.getCursorLocation().getLineNumber();
        SMInputCursor cursor = rule.childElementCursor();
        while (cursor.getNext() != null) {
            String nodeName = cursor.getLocalName();
            if (StringUtils.equalsIgnoreCase((String)"key", (String)nodeName)) {
                key = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"group", (String)nodeName)) {
                group = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"scope", (String)nodeName)) {
                scope = CppDependQuery.Scope.valueOf(StringUtils.trim((String)cursor.collectDescendantText(false)).toUpperCase());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"code", (String)nodeName)) continue;
            code = StringUtils.trim((String)cursor.collectDescendantText(false));
        }
        this.throwIfNull(key, line, "key");
        this.throwIfNull((Object)scope, line, "scope");
        this.throwIfNull(group, line, "group");
        this.throwIfNull(code, line, "code");
        return new CppDependQuery(key, group, scope, code);
    }

    private void throwIfNull(Object what, int line, String item) {
        if (what == null) {
            throw new AssertionError((Object)String.format("Rule at line %d has no %s", line, item));
        }
    }
}

