/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import org.sonar.plugins.cxx.cppdepend.CppDependQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryXmlSerializer {
    private static final String DeclareFile = "let file = %s.SourceDecls.Count() > 0 ? %s.SourceDecls.First().SourceFile.FilePath.ToStringOrIfNullToEmptyString(): \"\"\n";
    private static final String DeclareLine = "let line = %s.SourceDecls.Count() > 0 ? %s.SourceDecls.First().Line.ToString() : \"1\"\n";
    private final Document document;

    public QueryXmlSerializer(Document document) {
        this.document = document;
    }

    public Node serialize(CppDependQuery query) {
        Element node = this.document.createElement("Query");
        node.setAttribute("Active", "True");
        node.setAttribute("DisplayList", "True");
        node.setAttribute("DisplayStat", "False");
        node.setAttribute("IsCriticalRule", "True");
        node.appendChild(this.document.createCDATASection(this.getData(query)));
        return node;
    }

    private String getData(CppDependQuery query) {
        this.checkQuerySelectsVariable(query);
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("// <Name>%s</Name>\n", query.getKey()));
        builder.append(query.getCode());
        builder.append("\n\n");
        String variable = this.getVariableName(query.getScope());
        builder.append(String.format(DeclareFile, variable, variable));
        builder.append(String.format(DeclareLine, variable, variable));
        builder.append('\n');
        builder.append(String.format("select new { %s, file, line }", variable));
        return builder.toString();
    }

    private void checkQuerySelectsVariable(CppDependQuery query) {
        String pattern = String.format("from %s ", this.getVariableName(query.getScope()));
        if (!query.getCode().contains(pattern)) {
            throw new IllegalArgumentException(String.format("Rule %s is invalid: it should contain '%s'", query.getKey(), pattern));
        }
    }

    private String getVariableName(CppDependQuery.Scope scope) {
        return String.valueOf(scope.name().toLowerCase().charAt(0));
    }
}

