/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.cxx.cppdepend.CppDependFileMetric;
import org.sonar.plugins.cxx.cppdepend.CppDependResultParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SonarResultParser {
    private final Document doc;
    private final XPath xpath;
    private final ImmutableList.Builder<CppDependFileMetric> fileBuilder;
    private static final Logger LOG = LoggerFactory.getLogger(CppDependResultParser.class);

    SonarResultParser(Document doc) {
        this.doc = doc;
        this.xpath = XPathFactory.newInstance().newXPath();
        this.fileBuilder = ImmutableList.builder();
    }

    public static SonarResultParser fromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return new SonarResultParser(factory.newDocumentBuilder().parse(file));
    }

    @VisibleForTesting
    NodeList getQueries() throws XPathExpressionException {
        return (NodeList)this.xpath.compile("/Projects/Project/FileMetrics").evaluate(this.doc, XPathConstants.NODESET);
    }

    NodeList getCCRows(Node queryNode) throws XPathExpressionException {
        return (NodeList)this.xpath.compile("CCDist/CC").evaluate(queryNode, XPathConstants.NODESET);
    }

    boolean tryParseInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int parseInt(String value) {
        if (this.tryParseInt(value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public List<CppDependFileMetric> parse() throws XPathExpressionException {
        NodeList queries = this.getQueries();
        for (int i = 0; i < queries.getLength(); ++i) {
            Node query = queries.item(i);
            NodeList rows = this.getCCRows(queries.item(i));
            String path = ((Element)query).getAttribute("path");
            int nloc = this.parseInt(((Element)query).getAttribute("NLOC"));
            int ploc = this.parseInt(((Element)query).getAttribute("PLOC"));
            int pploc = this.parseInt(((Element)query).getAttribute("PPLOC"));
            int comments = this.parseInt(((Element)query).getAttribute("NBComments"));
            int cc = this.parseInt(((Element)query).getAttribute("CC"));
            int papi = this.parseInt(((Element)query).getAttribute("PAPI"));
            int upapi = this.parseInt(((Element)query).getAttribute("PUAPI"));
            int nbclasses = this.parseInt(((Element)query).getAttribute("NBClasses"));
            int nbmethods = this.parseInt(((Element)query).getAttribute("NBMethods"));
            int nbfiles = 1;
            CppDependFileMetric cppdependfm = new CppDependFileMetric(path, nbclasses, nbmethods, cc, comments, nloc, ploc, pploc, papi, upapi, nbfiles);
            for (int j = 0; j < rows.getLength(); ++j) {
                Element row = (Element)rows.item(j);
                int mcc = this.parseInt(row.getAttribute("val"));
                cppdependfm.CCDist.add(mcc);
            }
            this.fileBuilder.add((Object)cppdependfm);
        }
        return this.fileBuilder.build();
    }
}

