/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppdepend.cpd.channels;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import org.sonar.plugins.cxx.cppdepend.cpd.api.CxxTokenType;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class CharacterLiteralsChannel
extends Channel<Lexer> {
    private static final char EOF = '\uffff';
    private final StringBuilder sb = new StringBuilder();
    private int index;
    private char ch;

    public boolean consume(CodeReader code, Lexer output) {
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        this.index = 0;
        this.readPrefix(code);
        if (this.ch != '\'') {
            return false;
        }
        if (!this.read(code)) {
            return false;
        }
        for (int i = 0; i < this.index; ++i) {
            this.sb.append((char)code.pop());
        }
        output.addToken(new Token[]{Token.builder().setLine(line).setColumn(column).setURI(output.getURI()).setValueAndOriginalValue(this.sb.toString()).setType((TokenType)CxxTokenType.CHARACTER).build()});
        this.sb.setLength(0);
        return true;
    }

    private boolean read(CodeReader code) {
        ++this.index;
        while (code.charAt(this.index) != this.ch) {
            if (code.charAt(this.index) == '\uffff') {
                return false;
            }
            if (code.charAt(this.index) == '\\') {
                ++this.index;
            }
            ++this.index;
        }
        ++this.index;
        return true;
    }

    private void readPrefix(CodeReader code) {
        this.ch = code.charAt(this.index);
        if (this.ch == 'u' || this.ch == 'U' || this.ch == 'L') {
            ++this.index;
            this.ch = code.charAt(this.index);
        }
    }
}

