/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.utils;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.cxx.utils.EmptyReportException;

public abstract class CxxReportSensor
implements Sensor {
    public static final Logger LOG = Loggers.get(CxxReportSensor.class);
    private final Set<String> notFoundFiles = new HashSet<String>();
    private final Set<String> uniqueIssues = new HashSet<String>();
    private final org.sonar.api.measures.Metric metric;
    private int violationsCount;
    protected final Configuration configuration;

    protected CxxReportSensor(Configuration configuration, org.sonar.api.measures.Metric metric) {
        this.configuration = configuration;
        this.metric = metric;
    }

    public void execute(SensorContext context) {
        try {
            LOG.info("Searching reports by relative path with basedir '{}' and search prop '{}'", (Object)context.fileSystem().baseDir(), (Object)this.reportPathKey());
            List<File> reports = CxxReportSensor.getReports(this.configuration, context.fileSystem().baseDir(), this.reportPathKey());
            this.violationsCount = 0;
            for (File report : reports) {
                int prevViolationsCount = this.violationsCount;
                LOG.info("Processing report '{}'", (Object)report);
                try {
                    this.processReport(context, report);
                    LOG.debug("{} processed = {}", (Object)(this.metric == null ? "Issues" : this.metric.getName()), (Object)(this.violationsCount - prevViolationsCount));
                }
                catch (EmptyReportException e) {
                    LOG.warn("The report '{}' seems to be empty, ignoring.", (Object)report);
                }
            }
            LOG.info("{} processed = {}", (Object)(this.metric == null ? "Issues" : this.metric.getName()), (Object)this.violationsCount);
            if (this.metric != null) {
                context.newMeasure().forMetric((Metric)this.metric).on((InputComponent)context.module()).withValue((Serializable)Integer.valueOf(this.violationsCount)).save();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot feed the data into sonar, details: '" + String.valueOf(e) + "'", e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected String getStringProperty(String name, String def) {
        return this.configuration.get(name).orElse(def);
    }

    public static List<File> getReports(Configuration configuration, File moduleBaseDir, String reportPathPropertyKey) {
        ArrayList<File> reports = new ArrayList<File>();
        ArrayList<String> reportPaths = new ArrayList<String>();
        Optional valueOpt = configuration.get(reportPathPropertyKey);
        if (valueOpt.isPresent()) {
            reportPaths.addAll(Arrays.asList(((String)valueOpt.get()).split(",")));
        }
        if (!reportPaths.isEmpty()) {
            ArrayList<String> includes = new ArrayList<String>();
            for (String reportPath : reportPaths) {
                String normalizedPath = FilenameUtils.normalize((String)reportPath);
                if (normalizedPath != null && new File(normalizedPath).isAbsolute()) {
                    includes.add(normalizedPath);
                    continue;
                }
                normalizedPath = FilenameUtils.normalize((String)(moduleBaseDir.getAbsolutePath() + File.separator + reportPath));
                if (normalizedPath != null) {
                    includes.add(normalizedPath);
                    continue;
                }
                LOG.debug("Not a valid report path '{}'", (Object)reportPath);
            }
            LOG.debug("Normalized report includes to '{}'", includes);
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setIncludes(includes.toArray(new String[0]));
            directoryScanner.scan();
            String[] includeFiles = directoryScanner.getIncludedFiles();
            LOG.info("Scanner found '{}' report files", (Object)includeFiles.length);
            for (String found : includeFiles) {
                reports.add(new File(found));
            }
            if (reports.isEmpty()) {
                LOG.warn("Cannot find a report for '{}'", (Object)reportPathPropertyKey);
            } else {
                LOG.info("Parser will parse '{}' report files", (Object)reports.size());
            }
        } else {
            LOG.info("Undefined report path value for key '{}'", (Object)reportPathPropertyKey);
        }
        return reports;
    }

    protected void processReport(SensorContext context, File report) throws Exception {
    }

    protected String reportPathKey() {
        return "";
    }
}

