/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.utils;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class CxxUtils {
    public static final Logger LOG = Loggers.get(CxxUtils.class);

    private CxxUtils() {
    }

    public static String normalizePath(String filename) {
        try {
            return new File(filename).getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error("path normalizing of '{}' failed: '{}'", (Object)filename, (Object)e.toString());
            return null;
        }
    }

    public static String normalizePathFull(String filename, String baseDir) {
        File targetfile = new File(filename.trim());
        String filePath = targetfile.isAbsolute() ? CxxUtils.normalizePath(filename) : CxxUtils.normalizePath(baseDir + File.separator + filename);
        return filePath;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

